/*******************************************************************************
* Copyright (c) 2020 Mingyao Chuang
*
* All rights reserved.
* This program is free to use, but the ban on selling behavior.
* Modify the program must keep all the original text description,
* and can only comment out the original code (not allowed to delete).
*
* e-mail:mingyaochuang@gmail.com
*******************************************************************************/
'use strict';

goog.provide('Blockly.Arduino.dbsp');

goog.require('Blockly.Arduino');

Blockly.Arduino.dbsp_servo_id_all = function () {
	var code = '';
	if (this.getParent() !== null) {
		code = '0xff';
	}
	return [code, Blockly.Arduino.ORDER_ATOMIC];
};

Blockly.Arduino.dbsp_servo_id_inputer = function () {
	var code = '';
	if (this.getParent() !== null) {
		var stream = this.getFieldValue('stream');
		var order = this.getFieldValue('order');
		code = '0x' + stream + order;
	}
	return [code, Blockly.Arduino.ORDER_ATOMIC];
};

Blockly.Arduino.dbsp_action_content_inputer = function () {
	this.onchange(null);
	var code = '//';
	var root = this.getRootBlock();
	if (root !== null && root.tag === 'dbsp_action') {
		var stream = this.getFieldValue('stream');
		var order = this.getFieldValue('order');
		var degree = this.getFieldValue('degree');
		var interval = this.getFieldValue('interval') / 10;
		code = '\t0x' + stream + order + ', ' + degree + ', ' + interval;
		if (this.getNextBlock() !== null) {
			code += ',\n';
		}
		else {
			code += '\n';
		}
	}
	return [code, Blockly.Arduino.ORDER_ATOMIC];
};

Blockly.Arduino.dbsp_begin = function () {
	if (Blockly.Blocks.dbsp.vars_['initObjectCount'] === 1) {
		var dropdown_serial = this.getFieldValue('serial');
		var dropdown_baud = this.getFieldValue('baud');
		var rx = this.getFieldValue('rx');
		var tx = this.getFieldValue('tx');
		var delay = this.getFieldValue('delay');
		var var_name = Blockly.Blocks.dbsp.INSTANCE_NAME;

		Blockly.Arduino.definitions_['define_dbsp'] = '#include <DBSPController.h>\n';
		Blockly.Arduino.definitions_['var_dbsp'] = 'DBSPController ' + var_name + ';\n';

		if (this.isSoftwareSerial) {
			Blockly.Arduino.definitions_['define_dbsp'] = '#define SOFTWARE_SERIAL\n' + Blockly.Arduino.definitions_['define_dbsp'];
			Blockly.Arduino.setups_['setup_dbsp'] = var_name + '.begin(' + rx + ', ' + tx + ', ' + dropdown_baud + ');\n';
		}
		else {
			Blockly.Arduino.setups_['setup_dbsp'] = var_name + '.begin(&' + dropdown_serial + ', ' + dropdown_baud + ');\n';
		}
		Blockly.Arduino.setups_['setup_dbsp'] += '  ' + var_name + '.queryServoList(NULL);\n';
		if (delay > 0) {
			Blockly.Arduino.setups_['setup_dbsp'] += '  delay(' + delay + ');\n';
		}
	}
	return '';
};

Blockly.Arduino.dbsp_update = function () {
	var var_name = Blockly.Blocks.dbsp.INSTANCE_NAME;
	var code = var_name + '.update();\n';
	return code;
};

Blockly.Arduino.dbsp_readAngle = function () {
	var code = '';
	if (Blockly.Blocks.dbsp.vars_['initObjectCount'] === 1) {
		var id = Blockly.Arduino.valueToCode(this, 'sid', Blockly.Arduino.ORDER_ATOMIC) || '0x11';
		var stream = id >> 4;
		var order = id & 0xf;
		code = Blockly.Blocks.dbsp.INSTANCE_NAME + '.readAngle(0x' + stream + order + ')';
	}
	return [code, Blockly.Arduino.ORDER_ATOMIC];
};

Blockly.Arduino.dbsp_rotate = function () {
	var code = '';
	if (Blockly.Blocks.dbsp.vars_['initObjectCount'] === 1) {
		var id = Blockly.Arduino.valueToCode(this, 'sid', Blockly.Arduino.ORDER_ATOMIC) || '0x11';
		var degree = Blockly.Arduino.valueToCode(this, 'degree', Blockly.Arduino.ORDER_ATOMIC) || '0';
		var interval = Blockly.Arduino.valueToCode(this, 'interval', Blockly.Arduino.ORDER_ATOMIC) || '1000';
		code = Blockly.Blocks.dbsp.INSTANCE_NAME + '.rotate(' + id + ', ' + degree + ', ' + interval + ' / 10);\n';
	}
	return code;
};

Blockly.Arduino.dbsp_rotate_by_speed = function () {
	var code = '';
	if (Blockly.Blocks.dbsp.vars_['initObjectCount'] === 1) {
		var id = Blockly.Arduino.valueToCode(this, 'sid', Blockly.Arduino.ORDER_ATOMIC) || '0x11';
		var degree = Blockly.Arduino.valueToCode(this, 'degree', Blockly.Arduino.ORDER_ATOMIC) || '0';
		var speed = Blockly.Arduino.valueToCode(this, 'speed', Blockly.Arduino.ORDER_ATOMIC) || '60';
		code = Blockly.Blocks.dbsp.INSTANCE_NAME + '.rotateBySpeed(' + id + ', ' + degree + ', ' + speed + ');\n';
	}
	return code;
};

Blockly.Arduino.dbsp_action = function () {
	if (Blockly.Blocks.dbsp.vars_['initObjectCount'] === 1) {
		var name = this.getFieldValue('aname');
		var content = Blockly.Arduino.valueToCode(this, 'content', Blockly.Arduino.ORDER_ATOMIC) || '';
		if (content !== '') {
			var newContent = '';
			var scount = 1;
			while (1) {
				newContent = content.replace(',0', '');
				if (newContent.length === content.length) {
					break;
				}
				else {
					content = newContent;
					++scount;
				}
			}
			Blockly.Blocks.dbsp.vars_['dbsp_action_servo_count' + name] = scount;
			Blockly.Arduino.definitions_['define_dbsp_action' + name] =
			'ActionContent ' + name + '[' + scount + '] = {\n' + content + '};\n'
		}
	}
	return '';
};

Blockly.Arduino.dbsp_execute_action = function () {
	var code = '';
	if (Blockly.Blocks.dbsp.vars_['initObjectCount'] === 1) {
		var id = this.getFieldValue('aid');
		code = Blockly.Blocks.dbsp.INSTANCE_NAME + '.executeAction(' + id + ');\n';
	}
	return code;
};

Blockly.Arduino.dbsp_execute_action_array = function () {
	var code = '';
	if (Blockly.Blocks.dbsp.vars_['initObjectCount'] === 1) {
		var name = this.getFieldValue('aname');
		var servoCount = Blockly.Blocks.dbsp.vars_['dbsp_action_servo_count' + name] || 0;
		if (servoCount > 0) {
			code = Blockly.Blocks.dbsp.INSTANCE_NAME + '.executeAction(' + name + ', ' + servoCount + ');\n';
		}
	}
	return code;
};

Blockly.Arduino.dbsp_execute_macro = function () {
	var code = '';
	if (Blockly.Blocks.dbsp.vars_['initObjectCount'] === 1) {
		var id = this.getFieldValue('mid');
		code = Blockly.Blocks.dbsp.INSTANCE_NAME + '.executeMacro(' + id + ');\n';
	}
	return code;
};

Blockly.Arduino.dbsp_release = function () {
	var code = '';
	if (Blockly.Blocks.dbsp.vars_['initObjectCount'] === 1) {
		var id = Blockly.Arduino.valueToCode(this, 'sid', Blockly.Arduino.ORDER_ATOMIC) || '';
		code = Blockly.Blocks.dbsp.INSTANCE_NAME + '.release(' + id + ');\n';
	}
	return code;
};

Blockly.Arduino.dbsp_stop = function () {
	var code = '';
	if (Blockly.Blocks.dbsp.vars_['initObjectCount'] === 1) {
		var id = Blockly.Arduino.valueToCode(this, 'sid', Blockly.Arduino.ORDER_ATOMIC) || '';
		code = Blockly.Blocks.dbsp.INSTANCE_NAME + '.stop(' + id + ');\n';
	}
	return code;
};